package kap11_3.soapServer;

import jakarta.jws.WebService;

import soap.Student;
import soap.Leistung;
import soap.VerwaltungInterface;


@WebService( endpointInterface="soap.VerwaltungInterface" )
public class VerwaltungImpl implements VerwaltungInterface 
{
	@Override
	public int martikelnummerZuName(String name) 
	{
		System.out.print("matrikelNummerZuName: "+ name);
		Student s = Speicher.getSucheMatrikelNummerZuName(name);
		
		if(s != null)
		{
			System.out.println(" "+ s.getMatrikelNummer());
			return s.getMatrikelNummer();
		}
		
		System.out.println(" nicht gefunden");
		return -1;
	}

	@Override
	public Leistung[] studienleistungZuMartikelnummer(int matrikelNummer) 
	{
		System.out.print("StudienleistungZuMartikelnummer: "+ matrikelNummer);
		
		Student s = Speicher.getStudentenInfoZuMatrikelNummer(matrikelNummer);
		
		if(s != null)
		{
			System.out.println(" "+ s.getName() + " mit " + s.getLeistungen().length + " Leistungen");
			return s.getLeistungen();
		}
		
		System.out.println(" nicht gefunden");
		return null;
	}

	@Override
	public Student nameZuMatrikelnummer(int matrikelNummer) {
		{
			System.out.print("nameZuMartikelnummer: "+ matrikelNummer);
			
			Student s = Speicher.getStudentenInfoZuMatrikelNummer(matrikelNummer);
			
			if(s != null)
			{
				Student myStudent = new Student();
				
				myStudent.setMatrikelNummer(s.getMatrikelNummer());
				myStudent.setName(s.getName());
				myStudent.setLeistungen(null);
				
				System.out.println(" "+ s.getName());
				return myStudent;
			}
		
			System.out.println(" nicht gefunden");
			return null;
		}
	}

}




