package kap10_3_4;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;

public class UDPMulticastSender {
	InetAddress multicastAdresse;
	int multicastPort;
	MulticastSocket multicastSocket;
	byte[] bytePuffer;
	DatagramPacket udpPaket;

	public UDPMulticastSender(InetAddress multicastAdresse, int multicastPort) throws IOException {
		multicastSocket = new MulticastSocket();
		System.out.println("Sender Socket erzeugt");

		bytePuffer = new byte[10]; 
		udpPaket = new DatagramPacket(bytePuffer,bytePuffer.length);
		System.out.println("Sender Datenpaket erzeugt");
		this.multicastAdresse = multicastAdresse;
		this.multicastPort = multicastPort;
	}

	public void tuWas(int startWert) throws IOException, InterruptedException {
		int zahl = startWert;

		do {
			byte [] data = new byte[1];
			data[0] = (byte)--zahl;
			udpPaket.setData(data);
			udpPaket.setLength(data.length);
			udpPaket.setPort(multicastPort);
			udpPaket.setAddress(multicastAdresse);
			multicastSocket.send(udpPaket);
			System.out.println("Partner2 gesendet: " + zahl);
			Thread.sleep(1000);		
		}
		while(true);
	}

	public void disconnect() throws IOException {
		multicastSocket.close();
	}

	public static void main(String[] args) throws UnknownHostException, IOException, InterruptedException {
		UDPMulticastSender meinSender = new UDPMulticastSender(InetAddress.getByName("224.255.255.255"),4711);

		meinSender.tuWas(100);

		meinSender.disconnect();
	}
}