package kap10_3_4;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.UnknownHostException;

public class UDPMulticastReceiver {
	InetAddress multicastAdresse;
	int multicastPort;
	MulticastSocket multicastSocket;
	byte[] bytePuffer;
	DatagramPacket udpPaket;

	public UDPMulticastReceiver(InetAddress multicastAdresse, int multicastPort) throws IOException {
		multicastSocket = new MulticastSocket(multicastPort); 
		System.out.println("Receiver Socket erzeugt");
		
		// Der Socket muss an ein Netzwerkinterface gebunden werden
		// Unter Windows ist das sowas wie "eth0"; unter OS X  "en0"; unter Linux "eth0"
		multicastSocket.setNetworkInterface(NetworkInterface.getByName("en0"));
		System.out.println(multicastSocket.getNetworkInterface());
		
		multicastSocket.joinGroup(multicastAdresse);

		bytePuffer = new byte[10];
		udpPaket = new DatagramPacket(bytePuffer,bytePuffer.length);
		System.out.println("Receiver Datenpaket erzeugt");
		this.multicastAdresse = multicastAdresse;
		this.multicastPort = multicastPort;
	}

	public void tuWas() throws IOException {
		int zahl;

		do {
			multicastSocket.receive(udpPaket);
			zahl = udpPaket.getData()[0];
			System.out.println("Receiver Empfangen: "+zahl + " insgesamt " + udpPaket.getLength() + " Bytes.");
		}
		while(true);
	}

	public void disconnect() throws IOException {
		multicastSocket.close();
	}

	public static void main(String[] args) throws UnknownHostException, IOException {
		UDPMulticastReceiver meinEmpfaenger = new UDPMulticastReceiver(InetAddress.getByName("224.255.255.255"),4711);

		meinEmpfaenger.tuWas();

		meinEmpfaenger.disconnect();
	}
}