package kap10_3_3;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.UnknownHostException;

public class UDPBroadcastReceiver {
	int broadcastPort;
	DatagramSocket broadcastSocket;
	byte[] bytePuffer;
	DatagramPacket udpPaket;

	public UDPBroadcastReceiver(int broadcastPort) throws IOException {
		
		broadcastSocket = new DatagramSocket(broadcastPort); 
		System.out.println("Receiver Socket erzeugt");
		
		bytePuffer = new byte[10];
		udpPaket = new DatagramPacket(bytePuffer,bytePuffer.length);
		System.out.println("Receiver Datenpaket erzeugt");
		this.broadcastPort = broadcastPort;
	}

	public void tuWas() throws IOException {
		int zahl;

		do {
			broadcastSocket.receive(udpPaket);
			zahl = udpPaket.getData()[0];
			System.out.println("Receiver Empfangen: "+zahl + " insgesamt " + udpPaket.getLength() + " Bytes.");
		}
		while(true);
	}

	public void disconnect() throws IOException {
		broadcastSocket.close();
	}

	public static void main(String[] args) throws UnknownHostException, IOException {
		UDPBroadcastReceiver meinEmpfaenger = new UDPBroadcastReceiver(4711);

		meinEmpfaenger.tuWas();

		meinEmpfaenger.disconnect();
	}
}