package kap10_3;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class UDPSender {
	InetAddress seineAdresse;
	int seinPort;
	DatagramSocket udpSocket;
	byte[] bytePuffer;
	DatagramPacket udpPaket;

	public UDPSender(InetAddress seineAdresse, int seinPort) throws IOException {
		udpSocket = new DatagramSocket();
		System.out.println("Sender Socket erzeugt");
		bytePuffer = new byte[10]; 
		udpPaket = new DatagramPacket(bytePuffer,bytePuffer.length);
		System.out.println("Sender Datenpaket erzeugt");
		this.seineAdresse = seineAdresse;
		this.seinPort = seinPort;
	}

	public void tuWas(int startWert) throws IOException, InterruptedException {
		int zahl = startWert;

		do {
			byte [] data = new byte[1];
			data[0] = (byte)--zahl;
			udpPaket.setData(data);
			udpPaket.setLength(data.length);
			udpPaket.setPort(seinPort);
			udpPaket.setAddress(seineAdresse);
			udpSocket.send(udpPaket);
			System.out.println("Sender gesendet: "+zahl);
			Thread.sleep(1000);		
		}
		while(true);
	}

	public void disconnect() throws IOException {
		udpSocket.close();
	}

	public static void main(String[] args) throws UnknownHostException, IOException, InterruptedException {
		UDPSender meinSender = new UDPSender(InetAddress.getByName("127.0.0.1"),4711);

		meinSender.tuWas(100);

		meinSender.disconnect();
	}
}