package kap07_6;

import com.hivemq.client.mqtt.MqttClient;
import com.hivemq.client.mqtt.MqttGlobalPublishFilter;
import com.hivemq.client.mqtt.datatypes.MqttQos;
import com.hivemq.client.mqtt.datatypes.MqttTopic;
import com.hivemq.client.mqtt.mqtt3.Mqtt3BlockingClient;
import com.hivemq.client.mqtt.mqtt3.Mqtt3BlockingClient.Mqtt3Publishes;
import com.hivemq.client.mqtt.mqtt3.message.Mqtt3MessageType;
import com.hivemq.client.mqtt.mqtt3.message.publish.Mqtt3Publish;

public class MqttSubscriber {

	public static void main(String[] args) throws InterruptedException {
		
		System.out.println("Starte Client");
		Mqtt3BlockingClient client = MqttClient.builder()
				.useMqttVersion3()
				.identifier("myMqttReceiver") //+jetzt.toNanoOfDay()) // "Zufaellige" ID aus aktueller Zeit
				.serverHost("angewnwt.hof-university.de")
				.serverPort(1883)
				.buildBlocking();

		System.out.println("Verbinde Client");
		client.connectWith()
			.simpleAuth()
				.username("Mark")
				.password("Zuckerberg".getBytes())
				.applySimpleAuth()
			.cleanSession(false)//true)
			.send();

		System.out.println("Abonniere Client");
		client.subscribeWith()
			.topicFilter("dateTime/#")
			.qos(MqttQos.EXACTLY_ONCE)
			.send();

		System.out.println("Verarbeite empfangene Nachrichten");
		Mqtt3Publishes incomingMsg = 
	             client.publishes(MqttGlobalPublishFilter.SUBSCRIBED);
		
		System.out.println("Empfange Daten");
		String dayOfWeek = "leer";
		String hoursMin = "leer";
		String seconds = "leer";
		
		while(true) {
			
			// Empfangen/Abholen der Nachricht
			Mqtt3Publish rcvd = incomingMsg.receive();

			// Auslesen der Attribute und der Payload
			MqttTopic topic = rcvd.getTopic();
			MqttQos   qos = rcvd.getQos();
			Mqtt3MessageType  type = rcvd.getType();
			byte[]    payload = rcvd.getPayloadAsBytes();
						
			// Verarbeiten entsprechend Topic
			switch(topic.toString()) {
				case "dateTime/dayOfWeek":
					dayOfWeek = new String(payload);
					break;
				case "dateTime/HHMM":
					hoursMin = new String(payload);
					break;
				case "dateTime/seconds":
					seconds = new String(payload);
					break;
			}
			System.out.format("%s %s.%s\t", dayOfWeek, hoursMin, seconds);	
			// Debugausgabe
			System.out.format("Topic %s / Qos %s / Type %s", topic, qos, type);
			System.out.println();
		}
	}
}
