/*
 * Copyright (c) 2010, 2020 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Distribution License v. 1.0, which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */
package kap11_6_1.restServerHTTPErrors;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.Response.ResponseBuilder;

import studierende.Speicher;
import studierende.Student;

@Path("student")
public class VerwaltungService {

	// Pfad 1 und Pfad 2 der Server-Sitemap fuehren auf diese Methode
	// diese verzweigt je nach Aufruf mit oder ohne Query-Parameter 
	@GET
	//@Path("/")
	@Produces(MediaType.APPLICATION_JSON) 
	public Response getListeOderSuche(@QueryParam("name") String name) {
		System.out.print("getListeOderSuche: "+ name + " ");

		if(name == null)
			// Pfad 1: kein Parameter: gesamte Liste
			return getListeVonStudenten();
		else
			// Pfad 2: mit Parameter: nur ein Eintrag
			return getSucheMatrikelNummerZuName(name);
	}


	// Funktion fuer Pfad 1 der Server-Sitemap: Namen und Matrikelnummern aller Studenten
	public Response getListeVonStudenten() 
	{
		String ergebnisAlsJSON;
		ResponseBuilder responseBuilder;
		Response response;

		System.out.println("getListeVonStudenten");

		// GSON fuer Umwandlung in JSON
		Gson gson = new GsonBuilder().create();

		// Wir wollen nur einen Teil des Studentenarrays transportieren, deswegen muss Liste ueberarbeitet werden
		JsonArray nurMatrikelnummerUndName = new JsonArray();
		for(Student s : Speicher.getStudenten())
		{
			JsonObject dataset = new JsonObject();
			dataset.addProperty("matrikelNummer", s.matrikelNummer);
			dataset.addProperty("name", s.name);
			nurMatrikelnummerUndName.add(dataset);
		}
		ergebnisAlsJSON = gson.toJson(nurMatrikelnummerUndName);
		if (ergebnisAlsJSON==null) {
			// keine Daten gefunden ==> Fehlermeldung als HTTP-Status zurueckgeben
			// ResponseBuilder mit HTML Status 5xx instanziieren, Klartextnachricht anhaengen
			responseBuilder = Response.serverError();
			responseBuilder = responseBuilder.entity("500 Internal Server Error");
			// Response erzeugen
			response = responseBuilder.build();
			return response;
		} else {
			// Daten gefunden ==> HTTP-Status Erfolg und Daten in die Response
			responseBuilder = Response.ok(ergebnisAlsJSON, MediaType.APPLICATION_JSON);
			// Response erzeugen
			response = responseBuilder.build();
			return response;
		}
	}

	// Funktion fuer Pfad 2 der Server-Sitemap: Matrikelnummer zum Namen
	public Response getSucheMatrikelNummerZuName(String name) 
	{
		ResponseBuilder responseBuilder;
		Response response;
		Student myStudent = null;
		JsonObject matrikelnummer = null;
		String ergebnisAlsJSON;

		Gson gson = new GsonBuilder().create();

		System.out.print("getSucheMatrikelNummerZuName: "+ name);

		myStudent = Speicher.getSucheMatrikelNummerZuName(name);
		if(myStudent != null)
		{
			matrikelnummer = new JsonObject();
			matrikelnummer.addProperty("matrikelNummer", myStudent.matrikelNummer);
		}
		System.out.println(" "+ matrikelnummer);
		ergebnisAlsJSON = gson.toJson(matrikelnummer);
		if (matrikelnummer==null) {
			//JSON Fehlernachricht wird intanziiert
			ergebnisAlsJSON = gson.toJson("404 Not Found. The requested Name /"+name+" was not found on this server");
			//ResponseBuilder wird mit HTML Status 404 instanziiert
			responseBuilder = Response.status(Response.Status.NOT_FOUND);
			//Den ResponseBuilder wird zusaetzlich eine JSON Nachricht angehaengt
			responseBuilder = responseBuilder.entity(ergebnisAlsJSON);
			//Response wird aus ResponseBuilder instanziiert. Response enthaelt den Statuscode und eine Nachricht, 
			//die jetzt als akzeptiertes Format zurueckgeliefert werden kann
			response = responseBuilder.build();
			return response;
		} else {
			//ResponseBuilder wird mit HTML Status 200 und einer Nachricht von Typ JSON instanziiert
			responseBuilder = Response.ok(ergebnisAlsJSON, MediaType.APPLICATION_JSON);
			//Response wird aus ResponseBuilder instanziiert. Response enthaelt den Statuscode und eine Nachricht, 
			//die jetzt als akzeptiertes Format zurueckgeliefert werden kann
			response = responseBuilder.build();
			return response;
		}
	}

	// Funktion fuer Pfad 3 der Server-Sitemap: Name zu einer Matrikelnummer
	@GET
	@Path("/{matrikelNummer}")
	@Produces(MediaType.APPLICATION_JSON)
	public Response getStudentenInfoZuMatrikelNummer(@PathParam("matrikelNummer") int matrikelNummer) 
	{
		ResponseBuilder responseBuilder;
		Response response;
		Student myStudent = null;
		String ergebnisAlsJSON = "null";

		Gson gson = new GsonBuilder().create();

		System.out.print("getStudentenInfoZuMatrikelNummer: "+ matrikelNummer);

		myStudent = Speicher.getStudentenInfoZuMatrikelNummer(matrikelNummer);
		if(myStudent != null)
		{
			System.out.println(" "+ myStudent.name + " mit " + myStudent.leistungen.length + " Leistungen");

			// Wir wollen nur einen Teil transportieren, deswegen muss Liste ueberarbeitet werden
			JsonObject nurMatrikelnummerUndName = new JsonObject();
			nurMatrikelnummerUndName.addProperty("matrikelNummer", myStudent.matrikelNummer);
			nurMatrikelnummerUndName.addProperty("name", myStudent.name);
			ergebnisAlsJSON = gson.toJson(nurMatrikelnummerUndName);
			//ResponseBuilder wird mit HTML Status 200 und einer Nachricht von Typ JSON instanziiert
			responseBuilder = Response.ok(ergebnisAlsJSON, MediaType.APPLICATION_JSON);
			//Response wird aus ResponseBuilder instanziiert. Response enthaelt den Statuscode und eine Nachricht, 
			//die jetzt als akzeptiertes Format zurueckgeliefert werden kann
			response = responseBuilder.build();
			return response;
		}
		else {
			System.out.println(" nicht gefunden.");
			ergebnisAlsJSON = gson.toJson("404 Not Found. The requested matrikelNummer /"+matrikelNummer+" was not found on this server");
			//ResponseBuilder wird mit HTML Status 404 instanziiert
			responseBuilder = Response.status(Response.Status.NOT_FOUND);
			//Den ResponseBuilder wird zusaetzlich eine JSON Nachricht angehaengt
			responseBuilder = responseBuilder.entity(ergebnisAlsJSON);
			//Response wird aus ResponseBuilder instanziiert. Response enthaelt den Statuscode und eine Nachricht, 
			//die jetzt als akzeptiertes Format zurueckgeliefert werden kann
			response = responseBuilder.build();
			return response;

		}

	}

	// Funktion fuer Pfad 4 der Server-Sitemap: Leistungen zu einer Matrikelnummer
	@GET
	@Path("/{matrikelNummer}/leistung")
	@Produces(MediaType.APPLICATION_JSON)
	public Response getLeistungVonStudenten(@PathParam("matrikelNummer") int matrikelNummer) 
	{
		ResponseBuilder responseBuilder;
		Response response;
		Student myStudent = null;
		String ergebnisAlsJSON = "null";

		Gson gson = new GsonBuilder().create();

		System.out.print("getLeistungVonStudenten: "+ matrikelNummer);

		myStudent = Speicher.getStudentenInfoZuMatrikelNummer(matrikelNummer);
		if(myStudent != null)
		{
			System.out.println(" "+ myStudent.name + " mit " + myStudent.leistungen.length + " Leistungen");
			ergebnisAlsJSON = gson.toJson(myStudent.leistungen);
			//ResponseBuilder wird mit HTML Status 200 und einer Nachricht von Typ JSON instanziiert
			responseBuilder = Response.ok(ergebnisAlsJSON, MediaType.APPLICATION_JSON);
			//Response wird aus ResponseBuilder instanziiert. Response enthaelt den Statuscode und eine Nachricht, 
			//die jetzt als akzeptiertes Format zurueckgeliefert werden kann
			response = responseBuilder.build();
			return response;
		}
		else {
			System.out.println(" nicht gefunden.");
			ergebnisAlsJSON = gson.toJson("404 Not Found. The requested matrikelNummer /"+matrikelNummer+" was not found on this server");
			//ResponseBuilder wird mit HTML Status 404 instanziiert
			responseBuilder = Response.status(Response.Status.NOT_FOUND);
			//Den ResponseBuilder wird zusaetzlich eine JSON Nachricht angehaengt
			responseBuilder = responseBuilder.entity(ergebnisAlsJSON);
			//Response wird aus ResponseBuilder instanziiert. Response enthaelt den Statuscode und eine Nachricht, 
			//die jetzt als akzeptiertes Format zurueckgeliefert werden kann
			response = responseBuilder.build();
			return response;
		}
	}
}
