/*
 * Copyright (c) 2012, 2020 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Distribution License v. 1.0, which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */
package kap11_6_1.restServerHTTPErrors;

// Inspiriert durch https://github.com/eclipse-ee4j/jersey/tree/3.1.1/examples/helloworld-pure-jax-rs

import java.io.IOException;
import java.net.URI;

import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.glassfish.jersey.server.ResourceConfig;

import jakarta.ws.rs.core.UriBuilder;

public class RestServerApp {

	public static URI getBaseURI() {
		return UriBuilder.fromUri(
					"http://localhost/") // "Wurzel des Service" 
					.port(4434) 		 // Port des Service
					.build();
	}

	static HttpServer startServer() throws IOException {

		// Einfachen Webserver erzeugen und mit Service verbinden
		final HttpServer server = GrizzlyHttpServerFactory.createHttpServer(
				getBaseURI(),
				new ResourceConfig(VerwaltungService.class),
				false
				);
		
		// Thread fuer Service erzeugen und eine Abbruchmoeglichkeit einbauen
		Runtime.getRuntime().addShutdownHook(
				new Thread(new Runnable() {
					@Override
					public void run() {
						server.shutdownNow();
					}
				}));

		// Webserver mit Service starten
		server.start();

		return server;
	}

	public static void main(String[] args) throws IOException, InterruptedException {
		System.out.println("REST Server startet");

		startServer();

		System.out.println("Rest Server läuft unter " + getBaseURI());
		
		Thread.currentThread().join();
	}

}
