package kap11_3.soapServerException;

import jakarta.jws.WebService;
import kap11_3.soapServer.Speicher;
import soap.Leistung;
import soap.Student;

@WebService( endpointInterface="soapServerException.VerwaltungInterfaceException" )
public class VerwaltungImplException implements VerwaltungInterfaceException
{
	@Override
	public int martikelnummerZuName(String name) throws NichtGefundenException 
	{
		System.out.print("matrikelNummerZuName: "+ name);
		Student s = Speicher.getSucheMatrikelNummerZuName(name);
		
		if(s != null)
		{
			System.out.println(" "+ s.getMatrikelNummer());
			return s.getMatrikelNummer();
		}
		System.out.println(" nicht gefunden");
		throw new NichtGefundenException("unbekannter Name", 1);
	}

	@Override
	public Leistung[] studienleistungZuMartikelnummer(int matrikelNummer) throws NichtGefundenException 
	{
		System.out.print("StudienleistungZuMartikelnummer: "+ matrikelNummer);
		
		Student s = Speicher.getStudentenInfoZuMatrikelNummer(matrikelNummer);
		
		if(s != null)
		{
			System.out.println(" "+ s.getName() + " mit " + s.getLeistungen().length + " Leistungen");
			return s.getLeistungen();
		}
			System.out.println(" nicht gefunden");
		throw new NichtGefundenException("ungueltige Matrikelnummer",2);
	}
}
