package kap11_3.soapServer;

import soap.Student;
import soap.Leistung;

// Das ist eine Kopie der Klasse aus dem Package Studenten. 
// Der Server auf der Webseite hat eine andere Implementierung des Package im Package soap. 
// Deshalb können wir hier nicht die Klasse aus dem Package Studenten verwenden.  
public class Speicher {
	// Array, das die Studenten speichert
	// Kniff: Der Inhalt des Speichers existiert nur einmal, da static
	private static final Student[] studenten;

	// Kniff: Der Inhalt des Speichers wird durch diese Methode beim ersten Zugriff erzeugt
	static
	{
		// Datensaetze erzeugen
		studenten = Speicher.fuelleMitUnsinn(100);
	}

	// Methoden fuer den Zugriff auf die gespeicherten Daten
	public static Student[] getStudenten()
	{
		return studenten;
	}

	public static Student getSucheMatrikelNummerZuName(String name)
	{
		for(Student s : studenten)
		{
			if(s.getName().equals(name))
			{
				return s;
			}
		}
		return null;
	}

	public static Student getStudentenInfoZuMatrikelNummer(int matrikelNummer)
	{
		for(Student s : studenten)
		{
			if(s.getMatrikelNummer() == matrikelNummer)
			{
				return s;
			}
		}	
		return null;
	}	

	// Utility-Methoden
	public static Student[] fuelleMitUnsinn(int Zahl)
	{
		// Hilfsvariablen zum Erzeugen von Datensaetzen
		  final String [] vornamen = { "Mia","Ben","Emma","Jonas","Hannah","Leon","Sofia","Finn","Anna","Elias"};
		  final String [] nachnamen = {"Bauer","Becker","Fischer","Fuchs","Hartmann","Lang", "Jung","Hofmann","Huber"};
		  final String [] module = {"Analysis A","Lineare Algebra A","Analysis B","Lineare Algebra B","Numerik A",
				"Stochastik A","Stochastik B","Numerik partieller Differentialgleichungen 1","Numerik partieller Differentialgleichungen 2",
				"Baumechanik I (Statik starrer Koerper)","Baumechanik II (Elastomechanik)","Baumechanik III (Kinematik und Kinetik)",
				"Kontinuumsmechanik I","Modellbildung im Ingenieurwesen","Numerische Mechanik","Festkoerpermechanik","Finite Elemente II",
				"Grundlagen der Elektrotechnik","Umweltbiologie und -chemie","Stroemungsmechanik","Thermodynamik im Ueberblick",
				"Datenstrukturen, Algorithmen und Programmierung","Datenbanksysteme im Ingenieurwesen","Graphen und Netze","Baustoffkunde I",
				"Baustoffkunde II","Ausgleichungsrechnung und Statistik I","Ausgleichungsrechnung und Statistik II",
		"Projekte des Ingenieurwesens" };

		Student[] unsinn = new Student[Zahl];

		for(int i=0; i < Zahl; i++) {
			unsinn[i]=new Student();
			int vn_indx = (int)(Math.random()*vornamen.length);
			int nn_indx = (int)(Math.random()*nachnamen.length);
			unsinn[i].setName(vornamen[vn_indx] + " " + nachnamen[nn_indx]);
			unsinn[i].setMatrikelNummer(vn_indx * 100 + nn_indx + i * 10000);
			int notenZahl = (int)(Math.random()*8);
			if(notenZahl >= 1) {
				Leistung[] leistungen = new Leistung[notenZahl];
				for(int j=0; j < notenZahl; j++) {
					int mod_indx = (int)(Math.random()*module.length);
					leistungen[j] = new Leistung();
					leistungen[j].setModul(module[mod_indx]);
					leistungen[j].setNote((int)(Math.random()*5) + 1);
				}
				unsinn[i].setLeistungen(leistungen);
			}
			else
				unsinn[i].setLeistungen(null);
		}
		return unsinn;
	}

	public static boolean sindArraysGleich(Student[] a, Student[] b) {
		boolean istUnGleich = false;
		if(a.length == b.length)
		{
			for(int i=0; i < a.length; i++) {
				istUnGleich |= a[i].getMatrikelNummer() != b[i].getMatrikelNummer();
				istUnGleich |= !(a[i].getName().equals(b[i].getName()));
				if(a[i].getLeistungen() != null) {
					for(int j=0; j < a[i].getLeistungen().length; j++) {
						istUnGleich |= !(a[i].getLeistungen()[j].getModul().equals(b[i].getLeistungen()[j].getModul())) ;
						istUnGleich |= a[i].getLeistungen()[j].getNote() != b[i].getLeistungen()[j].getNote() ;
					}
				}
				if(istUnGleich)
					System.out.println("Ungleich a="+ a + "| b=" + b);
			}
		}
		else
			istUnGleich = true;

		return !istUnGleich;
	}
}
