package kap10_3_3;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class UDPBroadcastSender {
	InetAddress braodcastAdresse;
	int broadcastPort;
	DatagramSocket broadcastSocket;
	byte[] bytePuffer;
	DatagramPacket udpPaket;

	public UDPBroadcastSender(InetAddress broadcastAdresse, int broadcastPort) throws IOException {
		broadcastSocket = new DatagramSocket();
		System.out.println("Sender Socket erzeugt");
	
		bytePuffer = new byte[10]; 
		udpPaket = new DatagramPacket(bytePuffer,bytePuffer.length);
		System.out.println("Sender Datenpaket erzeugt");
		this.braodcastAdresse = broadcastAdresse;
		this.broadcastPort = broadcastPort;
	}

	public void tuWas(int startWert) throws IOException, InterruptedException {
		int zahl = startWert;

		do {
			byte [] data = new byte[1];
			data[0] = (byte)--zahl;
			udpPaket.setData(data);
			udpPaket.setLength(data.length);
			udpPaket.setPort(broadcastPort);
			udpPaket.setAddress(braodcastAdresse);
			broadcastSocket.send(udpPaket);
			System.out.println("Partner2 gesendet: " + zahl);
			Thread.sleep(1000);		
		}
		while(true);
	}

	public void disconnect() throws IOException {
		broadcastSocket.close();
	}

	public static void main(String[] args) throws UnknownHostException, IOException, InterruptedException {
		UDPBroadcastSender meinSender = new UDPBroadcastSender(
				InetAddress.getByName("255.255.255.255"),4711); // alle Rechner innerhalb des Firmennetzes

		meinSender.tuWas(100);

		meinSender.disconnect();
	}
}