package kap07_6;

import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;

import com.hivemq.client.mqtt.MqttClient;
import com.hivemq.client.mqtt.datatypes.MqttQos;
import com.hivemq.client.mqtt.mqtt3.Mqtt3BlockingClient;

public class MqttPublisher {

	public static void main(String[] args) throws InterruptedException {
		LocalTime jetzt = LocalTime.now();

		System.out.println("Starte Client");
		Mqtt3BlockingClient client = MqttClient.builder()
				.useMqttVersion3()
				.identifier("myMqttPublisher"+jetzt.toNanoOfDay()) // "Zufaellige" ID aus aktueller Zeit
				.serverHost("angewnwt.hof-university.de")
				.serverPort(1883)
				.buildBlocking();

		System.out.println("Verbinde Client");
		client.connectWith()
		.simpleAuth()
			.username("Mark")
			.password("Zuckerberg".getBytes())
		.applySimpleAuth()
		.willPublish()
			.topic("dateTime/broken")
			.payload("not available".getBytes())
			.retain(true)
			.applyWillPublish()
		.cleanSession(false)
		.send();

		System.out.println("Starte Versand der Nachrichten");
		int i = 0; // Zaehler fuer periodischen Versand
		while(true) {

			// Datum und Zeit abrufen und formatieren
			LocalDate date = LocalDate.now();
			LocalTime time = LocalTime.now();
			DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("EEE");
			DateTimeFormatter timeHHMM = DateTimeFormatter.ofPattern("HH:mm");
			DateTimeFormatter timeSec = DateTimeFormatter.ofPattern("ss,S");
			String dayOfWeek = dateFormat.format(date);
			String hoursMin = timeHHMM.format(time);
			String seconds = timeSec.format(time);

			// je nach Wiederholung Nachrichten verschicken
			switch(i++) {
			case 0: // beim ersten Durchlauf
				System.out.println("Sende: " + dayOfWeek);
				client.publishWith()
				.topic("dateTime/dayOfWeek")
				.payload(dayOfWeek.getBytes())
				.qos(MqttQos.AT_LEAST_ONCE)
				.retain(true)
				.send();
				// break absichtlich weggelassen, um auch naechste Nachricht zu senden
			case 10: case 20: case 30: case 40: case 50: // alle 10 Sekunden
				System.out.println("Sende: " + hoursMin);
				client.publishWith()
				.topic("dateTime/HHMM")
				.payload(hoursMin.getBytes())
				.qos(MqttQos.AT_LEAST_ONCE)
				.retain(true)
				.send();
				// break absichtlich weggelassen, um auch naechste Nachricht zu senden
			default: // jede Sekunde
				System.out.println("Sende: " + seconds);
				client.publishWith()
				.topic("dateTime/seconds")
				.payload(seconds.getBytes())
				.qos(MqttQos.AT_LEAST_ONCE)
				.retain(false)
				.send();
				// alle 60 Sekunden von vorne beginnen
				if(i >= 60) {
					i = 0;
				}
				break;
			}

			// eine Sekunde warten
			Thread.sleep(1000);
		}			
	}
}
