/*
 * Decompiled with CFR 0.152.
 */
package soap;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.sun.net.httpserver.HttpExchange;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.Paths;
import java.util.LinkedList;
import javax.annotation.Resource;
import javax.jws.WebService;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.handler.MessageContext;
import soap.Leistung;
import soap.Request;
import soap.Speicher;
import soap.Student;
import soap.VerwaltungInterface;

@WebService(endpointInterface="soap.VerwaltungInterface")
public class VerwaltungImpl
implements VerwaltungInterface {
    private static final File soap = Paths.get("/var/www/html/Webservices/soap.txt", new String[0]).toFile();
    static LinkedList<Request> requestArray = new LinkedList();
    Gson gson = new GsonBuilder().create();
    private final int maxRequestArrayLength = 10;
    @Resource
    private WebServiceContext webServiceContext;

    public synchronized void saveRequest(Request request) {
        if (requestArray.size() >= 10) {
            requestArray.removeLast();
        }
        requestArray.addFirst(request);
        String req = this.gson.toJson(requestArray);
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(soap), "utf-8"));
            writer.write(req);
        }
        catch (IOException e) {
            System.err.println("cannot save Request to file");
        }
    }

    public String getInfo() {
        MessageContext messageContext = this.webServiceContext.getMessageContext();
        HttpExchange httpExchange = (HttpExchange)messageContext.get((Object)"com.sun.xml.internal.ws.http.exchange");
        return String.valueOf(httpExchange.getRemoteAddress().getHostString()) + ":" + httpExchange.getRemoteAddress().getPort();
    }

    public int martikelnummerZuName(String name) {
        Request request = new Request();
        request.setDate();
        request.setClient(this.getInfo());
        request.setRequest("matrikelNummerZuName(" + name + ")");
        Student s = Speicher.getSucheMatrikelNummerZuName(name);
        if (s != null) {
            request.setReply(Integer.toString(s.matrikelNummer));
            this.saveRequest(request);
            return s.matrikelNummer;
        }
        request.setReply("nicht gefunden");
        this.saveRequest(request);
        return -1;
    }

    public Leistung[] studienleistungZuMartikelnummer(int matrikelNummer) {
        String leistung = "";
        Request request = new Request();
        request.setDate();
        request.setClient(this.getInfo());
        request.setRequest("studienleistungZuMartikelnummer(" + Integer.toString(matrikelNummer) + ")");
        Student s = Speicher.getStudentenInfoZuMatrikelNummer(matrikelNummer);
        if (s != null) {
            if (s.leistungen != null) {
                Leistung[] leistungArray = s.leistungen;
                int n = s.leistungen.length;
                int n2 = 0;
                while (n2 < n) {
                    Leistung l = leistungArray[n2];
                    leistung = String.valueOf(leistung) + l.modul + ":" + l.note + "| ";
                    ++n2;
                }
                request.setReply(leistung);
            } else {
                request.setReply("keine Leistungen");
            }
            this.saveRequest(request);
            return s.leistungen;
        }
        request.setReply("nicht gefunden");
        this.saveRequest(request);
        return null;
    }

    public Student nameZuMatrikelnummer(int matrikelNummer) {
        Request request = new Request();
        request.setDate();
        request.setClient(this.getInfo());
        request.setRequest("nameZuMatrikelnummer(" + Integer.toString(matrikelNummer) + ")");
        Student s = Speicher.getStudentenInfoZuMatrikelNummer(matrikelNummer);
        if (s != null) {
            Student myStudent = new Student();
            myStudent.matrikelNummer = s.matrikelNummer;
            myStudent.name = s.name;
            myStudent.leistungen = null;
            request.setReply(myStudent.name);
            this.saveRequest(request);
            return myStudent;
        }
        request.setReply("nicht gefunden");
        this.saveRequest(request);
        return null;
    }
}

