/*
 * Decompiled with CFR 0.152.
 */
package restServer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.Paths;
import java.util.LinkedList;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.jws.WebMethod;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.glassfish.grizzly.http.server.Request;
import restServer.Leistung;
import restServer.Req;
import restServer.Speicher;
import restServer.Student;

@Path(value="/student")
public class VerwaltungService {
    @Inject
    private Provider<Request> sRequest;
    static final String webContextPath = "/student";
    private static final File rest = Paths.get("/var/www/html/Webservices/rest.txt", new String[0]).toFile();
    static LinkedList<Req> requestArray = new LinkedList();
    Gson gson = new GsonBuilder().create();
    private final int maxRequestArrayLength = 10;

    public synchronized void saveRequest(Req request) {
        if (requestArray.size() >= 10) {
            requestArray.removeLast();
        }
        requestArray.addFirst(request);
        String req = this.gson.toJson(requestArray);
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(rest), "utf-8"));
            writer.write(req);
        }
        catch (IOException e) {
            System.err.println("cannot save Request to file");
        }
    }

    @WebMethod
    public String getInfo() {
        String remoteClient = String.valueOf(((Request)this.sRequest.get()).getRemoteAddr()) + ":" + ((Request)this.sRequest.get()).getRemotePort();
        return remoteClient;
    }

    public String getListeVonStudenten() {
        String ergebnisAlsJSON = null;
        Req request = new Req();
        request.setDate();
        request.setClient(this.getInfo());
        request.setRequest("getListeVonStudenten()");
        String reply = "";
        Gson gson = new GsonBuilder().create();
        JsonArray nurMatrikelnummerUndName = new JsonArray();
        Student[] studentArray = Speicher.getStudenten();
        int n = studentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Student s = studentArray[n2];
            JsonObject dataset = new JsonObject();
            dataset.addProperty("matrikelNummer", (Number)s.matrikelNummer);
            dataset.addProperty("name", s.name);
            nurMatrikelnummerUndName.add((JsonElement)dataset);
            reply = String.valueOf(reply) + s.matrikelNummer + " " + s.name + "| ";
            ++n2;
        }
        ergebnisAlsJSON = gson.toJson((JsonElement)nurMatrikelnummerUndName);
        if (ergebnisAlsJSON == null) {
            request.setReply("nicht gefunden");
        } else {
            request.setReply(reply);
        }
        this.saveRequest(request);
        return ergebnisAlsJSON;
    }

    public String getSucheMatrikelNummerZuName(String name) {
        Req request = new Req();
        request.setDate();
        request.setClient(this.getInfo());
        request.setRequest("getSucheMatrikelNummerZuName(" + name + ")");
        Student myStudent = null;
        JsonObject matrikelnummer = null;
        String ergebnisAlsJSON = null;
        Gson gson = new GsonBuilder().create();
        myStudent = Speicher.getSucheMatrikelNummerZuName(name);
        if (myStudent != null) {
            matrikelnummer = new JsonObject();
            matrikelnummer.addProperty("matrikelNummer", (Number)myStudent.matrikelNummer);
        }
        ergebnisAlsJSON = gson.toJson(matrikelnummer);
        if (matrikelnummer == null) {
            request.setReply("nicht gefunden");
        } else {
            request.setReply(Integer.toString(myStudent.matrikelNummer));
        }
        this.saveRequest(request);
        return ergebnisAlsJSON;
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    public String getListeOderSuche(@QueryParam(value="name") String name) {
        if (name == null) {
            return this.getListeVonStudenten();
        }
        return this.getSucheMatrikelNummerZuName(name);
    }

    @GET
    @Path(value="/{matrikelNummer}")
    @Produces(value={"application/json"})
    public String getStudentenInfoZuMatrikelNummer(@PathParam(value="matrikelNummer") int matrikelNummer) {
        Student myStudent = null;
        String ergebnisAlsJSON = null;
        Req request = new Req();
        request.setDate();
        request.setClient(this.getInfo());
        request.setRequest("getStudentenInfoZuMatrikelNummer(" + Integer.toString(matrikelNummer) + ")");
        Gson gson = new GsonBuilder().create();
        myStudent = Speicher.getStudentenInfoZuMatrikelNummer(matrikelNummer);
        if (myStudent != null) {
            JsonObject nurMatrikelnummerUndName = new JsonObject();
            nurMatrikelnummerUndName.addProperty("matrikelNummer", (Number)myStudent.matrikelNummer);
            nurMatrikelnummerUndName.addProperty("name", myStudent.name);
            ergebnisAlsJSON = gson.toJson((JsonElement)nurMatrikelnummerUndName);
            request.setReply(myStudent.name);
        } else {
            request.setReply("nicht gefunden");
        }
        this.saveRequest(request);
        return ergebnisAlsJSON;
    }

    @GET
    @Path(value="/{matrikelNummer}/leistung")
    @Produces(value={"application/json"})
    public String getLeistungVonStudenten(@PathParam(value="matrikelNummer") int matrikelNummer) {
        Student myStudent = null;
        String ergebnisAlsJSON = null;
        Req request = new Req();
        request.setDate();
        request.setClient(this.getInfo());
        request.setRequest("getLeistungVonStudenten(" + Integer.toString(matrikelNummer) + ")");
        String reply = "";
        Gson gson = new GsonBuilder().create();
        myStudent = Speicher.getStudentenInfoZuMatrikelNummer(matrikelNummer);
        if (myStudent != null) {
            ergebnisAlsJSON = gson.toJson((Object)myStudent.leistungen);
            if (myStudent.leistungen != null) {
                Leistung[] leistungArray = myStudent.leistungen;
                int n = myStudent.leistungen.length;
                int n2 = 0;
                while (n2 < n) {
                    Leistung l = leistungArray[n2];
                    reply = String.valueOf(reply) + l.modul + ":" + l.note + "| ";
                    ++n2;
                }
                request.setReply(reply);
            } else {
                request.setReply("Keine Leistungen");
            }
        } else {
            request.setReply("nicht gefunden");
        }
        this.saveRequest(request);
        return ergebnisAlsJSON;
    }
}

