/*
 * Decompiled with CFR 0.152.
 */
package tcpServer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.LinkedList;
import tcpServer.Befehl;
import tcpServer.Leistung;
import tcpServer.Request;
import tcpServer.Speicher;
import tcpServer.Student;

public class ClientHandler
extends Thread {
    Socket clientSocket;
    InputStream inFromClient;
    OutputStream outToClient;
    private static final File eigenbau = Paths.get("/var/www/html/Webservices/eigenbau.txt", new String[0]).toFile();
    static LinkedList<Request> requestArray = new LinkedList();
    Gson gson = new GsonBuilder().create();
    private final int maxRequestArrayLength = 10;

    public ClientHandler(Socket clientSocket) throws IOException {
        this.clientSocket = clientSocket;
        this.inFromClient = clientSocket.getInputStream();
        this.outToClient = clientSocket.getOutputStream();
    }

    @Override
    public void run() {
        try {
            while (true) {
                Befehl antwort;
                byte[] bytes;
                int read;
                if ((read = this.inFromClient.read(bytes = new byte[6], 0, 6)) == -1) {
                    this.schliesseVerbindung();
                    return;
                }
                Befehl befehl = new Befehl();
                befehl.anfrage = new String(bytes, 0, 3, Charset.forName("ASCII"));
                String anhangLaenge = new String(bytes, 3, 3, Charset.forName("ASCII"));
                int laenge = Integer.parseInt(anhangLaenge);
                if (laenge > 0) {
                    bytes = new byte[laenge];
                    this.inFromClient.read(bytes, 0, laenge);
                    befehl.anhang = new String(bytes, 0, laenge, Charset.forName("UTF-8"));
                }
                if (befehl.anfrage.contains("MAT")) {
                    antwort = new Befehl();
                    antwort.anfrage = "ANT";
                    Request request = new Request();
                    request.setDate();
                    request.setClient(this.clientSocket.getInetAddress() + ":" + this.clientSocket.getPort());
                    request.setRequest("getSucheMatrikelNummerZuName(" + befehl.anhang + ")");
                    Student myStudent = Speicher.getSucheMatrikelNummerZuName(befehl.anhang);
                    if (myStudent != null) {
                        antwort.anhang = String.valueOf(myStudent.matrikelNummer);
                        request.setReply(Integer.toString(myStudent.matrikelNummer));
                    } else {
                        request.setReply("nicht gefunden");
                    }
                    this.saveRequest(request);
                    this.outToClient.write(antwort.baueBefehlString());
                    continue;
                }
                if (befehl.anfrage.contains("STU")) {
                    antwort = new Befehl();
                    antwort.anfrage = "ANT";
                    int matrikelNummer = Integer.parseInt(befehl.anhang);
                    Request request = new Request();
                    request.setDate();
                    request.setClient(this.clientSocket.getInetAddress() + ":" + this.clientSocket.getPort());
                    request.setRequest("getStudentenInfoZuMatrikelNummer(" + befehl.anhang + ")");
                    Student myStudent = Speicher.getStudentenInfoZuMatrikelNummer(matrikelNummer);
                    if (myStudent != null) {
                        antwort.anhang = String.valueOf(myStudent.matrikelNummer) + ";" + myStudent.name;
                        request.setReply(myStudent.name);
                    } else {
                        request.setReply("nicht gefunden");
                    }
                    this.saveRequest(request);
                    this.outToClient.write(antwort.baueBefehlString());
                    continue;
                }
                if (!befehl.anfrage.contains("LEI")) continue;
                antwort = new Befehl();
                antwort.anfrage = "ANT";
                int matrikelNummer = Integer.parseInt(befehl.anhang);
                String reply = "";
                Request request = new Request();
                request.setDate();
                request.setClient(this.clientSocket.getInetAddress() + ":" + this.clientSocket.getPort());
                request.setRequest("getStudentenInfoZuMatrikelNummer(" + befehl.anhang + ")");
                Student myStudent = Speicher.getStudentenInfoZuMatrikelNummer(matrikelNummer);
                if (myStudent != null) {
                    if (myStudent.leistungen != null) {
                        Leistung[] leistungArray = myStudent.leistungen;
                        int n = myStudent.leistungen.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Leistung l = leistungArray[n2];
                            antwort.anhang = String.valueOf(antwort.anhang) + l.modul + ";" + l.note + "|";
                            reply = String.valueOf(reply) + l.modul + ":" + l.note + "| ";
                            ++n2;
                        }
                        request.setReply(reply);
                    } else {
                        request.setReply("Keine Leistungen");
                    }
                } else {
                    request.setReply("nicht gefunden");
                }
                this.saveRequest(request);
                this.outToClient.write(antwort.baueBefehlString());
            }
        }
        catch (Exception e) {
            if (!this.clientSocket.isConnected()) {
                try {
                    this.schliesseVerbindung();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            e.printStackTrace();
            return;
        }
    }

    public void schliesseVerbindung() throws IOException {
        this.outToClient.close();
        this.inFromClient.close();
        this.clientSocket.close();
    }

    public void saveRequest(Request request) {
        if (requestArray.size() >= 10) {
            requestArray.removeLast();
        }
        requestArray.addFirst(request);
        String req = this.gson.toJson(requestArray);
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(eigenbau), "utf-8"));){
                writer.write(req);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            System.err.println("cannot save Request to file");
        }
    }
}

